%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   GUI -- pop-up menu for the permittivity table of materials


function varargout = RelPermittivity(varargin)
% RELPERMITTIVITY M-file for RelPermittivity.fig
%      RELPERMITTIVITY, by itself, creates a new RELPERMITTIVITY or raises the existing
%      singleton*.
%
%      H = RELPERMITTIVITY returns the handle to a new RELPERMITTIVITY or the handle to
%      the existing singleton*.
%
%      RELPERMITTIVITY('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RELPERMITTIVITY.M with the given input arguments.
%
%      RELPERMITTIVITY('Property','Value',...) creates a new RELPERMITTIVITY or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before RelPermittivity_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to RelPermittivity_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help RelPermittivity

% Last Modified by GUIDE v2.5 15-Aug-2012 12:59:27

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @RelPermittivity_OpeningFcn, ...
                   'gui_OutputFcn',  @RelPermittivity_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RelPermittivity is made visible.
function RelPermittivity_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to RelPermittivity (see VARARGIN)

% Import the adequate relative permittivity
handles.blank = '';
handles.Air = '1.005';
handles.Alcohol = '25';
handles.Alumina = '8.8';
handles.Amber = '2.7';
handles.Ammonia = '22';
handles.Animal = '10';
handles.Bakelite = '4.74';
handles.Barium = '1,200';
handles.Diamond = '5-6';
handles.DrySoil = '2-6';
handles.Freon = '1';
handles.FusedSilica = '3.8';
handles.GalliumArsenide = '13';
handles.Germanium = '16';
handles.Glass = '4-10';
handles.Glycerin = '50';
handles.Human = '10';
handles.Ice = '75';
handles.Marble = '8';
handles.Mica = '5.4';
handles.Neoprene = '6.6';
handles.Nylon = '3.6-4.5';
handles.Oil = '2.3';
handles.Paper = '1.3-3';
handles.Paraffin = '2.1';
handles.Plexiglass = '3.4';
handles.Polyethylene = '2.25';
handles.Polystyrene = '2.56';
handles.Polyurethane = '1.1';
handles.Porcelain = '6';
handles.PVC = '2.7';
handles.Quartz = '5';
handles.Rubber = '2.4-3';
handles.Rutile = '89-173';
handles.Silicon = '11.9';
handles.SiliconNitride = '7.2';
handles.SodiumChloride = '5.9';
handles.Steatite = '5.8';
handles.Styrofoam = '1.03';
handles.Sulfur = '4';
handles.Tantalum = '25';
handles.Teflon = '2.1';
handles.Vacuum = '1';
handles.Vaseline = '2.16';
handles.Water = '81';
handles.WetSoil = '5-15';
handles.Wood = '2-5';

% Choose default command line output for RelPermittivity
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

set(0,'units','inches');
screenSize = get(0,'ScreenSize');
set(hObject,'Units','inches','Position',[screenSize(3)/2-(3.9375/2),screenSize(4)/2-(1.5729/2),3.9375,1.5729]);

% UIWAIT makes RelPermittivity wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = RelPermittivity_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Determine the selected data set.

% Set current data to the selected data set.
switch get(handles.popupmenu1,'Value')
case 1 %''
    handles.current_data = handles.blank;
    set(handles.text2,'String',handles.current_data);
case 2 %'Air'
   handles.current_data = handles.Air;
   set(handles.text2,'String',handles.current_data);
case 3 %'Alcohol (ethyl)'
   handles.current_data = handles.Alcohol;
   set(handles.text2,'String',handles.current_data);
case 4 %'Alumina' 
   handles.current_data = handles.Alumina;
   set(handles.text2,'String',handles.current_data);
case 5 %'Amber'
   handles.current_data = handles.Amber;
   set(handles.text2,'String',handles.current_data);
case 6 %'Ammonia (liquid)'
   handles.current_data = handles.Ammonia;
   set(handles.text2,'String',handles.current_data);
case 7 %'Animal muscle'
   handles.current_data = handles.Animal;
   set(handles.text2,'String',handles.current_data);
case 8 %'Bakelite'
   handles.current_data = handles.Bakelite;
   set(handles.text2,'String',handles.current_data);
case 9 %'Barium titanate'
   handles.current_data = handles.Barium;
   set(handles.text2,'String',handles.current_data);
case 10 %'Diamond'
   handles.current_data = handles.Diamond;
   set(handles.text2,'String',handles.current_data);
case 11 %'Dry soil'
   handles.current_data = handles.DrySoil;
   set(handles.text2,'String',handles.current_data);
case 12 %'Freon'
   handles.current_data = handles.Freon;
   set(handles.text2,'String',handles.current_data);
case 13 %'Fused silica'
   handles.current_data = handles.FusedSilica;
   set(handles.text2,'String',handles.current_data);
case 14 %'Gallium arsenide'
   handles.current_data = handles.GalliumArsenide;
   set(handles.text2,'String',handles.current_data);
case 15 %'Germanium'
   handles.current_data = handles.Germanium;
   set(handles.text2,'String',handles.current_data);
case 16 %'Glass'
   handles.current_data = handles.Glass;
   set(handles.text2,'String',handles.current_data);
case 17 %'Glycerin'
   handles.current_data = handles.Glycerin;
   set(handles.text2,'String',handles.current_data);
case 18 %'Human muscle'
   handles.current_data = handles.Human;
   set(handles.text2,'String',handles.current_data);
case 19 %'Ice'
   handles.current_data = handles.Ice;
   set(handles.text2,'String',handles.current_data);
case 20 %'Marble'
   handles.current_data = handles.Marble;
   set(handles.text2,'String',handles.current_data);
case 21 %'Mica (ruby)'
   handles.current_data = handles.Mica;
   set(handles.text2,'String',handles.current_data);
case 22 %'Neoprene'
   handles.current_data = handles.Neoprene;
   set(handles.text2,'String',handles.current_data);
case 23 %'Nylon'
   handles.current_data = handles.Nylon;
   set(handles.text2,'String',handles.current_data);
case 24 %'Oil'
   handles.current_data = handles.Oil;
   set(handles.text2,'String',handles.current_data);
case 25 %'Paper'
   handles.current_data = handles.Paper;
   set(handles.text2,'String',handles.current_data);
case 26 %'Paraffin'
   handles.current_data = handles.Paraffin;
   set(handles.text2,'String',handles.current_data);
case 27 %'Plexiglass'
   handles.current_data = handles.Plexiglass;
   set(handles.text2,'String',handles.current_data);
case 28 %'Polyethylene'
   handles.current_data = handles.Polyethylene;
   set(handles.text2,'String',handles.current_data);
case 29 %'Polystyrene'
   handles.current_data = handles.Polystyrene;
   set(handles.text2,'String',handles.current_data);
case 30 %'Polyurethane foam'
   handles.current_data = handles.Polyurethane;
   set(handles.text2,'String',handles.current_data);
case 31 %'Porcelain'
   handles.current_data = handles.Porcelain;
   set(handles.text2,'String',handles.current_data);
case 32 %'PVC'
   handles.current_data = handles.PVC;
   set(handles.text2,'String',handles.current_data);
case 33 %'Quartz'
   handles.current_data = handles.Quartz;
   set(handles.text2,'String',handles.current_data);
case 34 %'Rubber'
   handles.current_data = handles.Rubber;
   set(handles.text2,'String',handles.current_data);
 case 35 %'Rutile'
   handles.current_data = handles.Rutile;
   set(handles.text2,'String',handles.current_data);
case 36 %'Silicon'
   handles.current_data = handles.Silicon;
   set(handles.text2,'String',handles.current_data);
case 37 %'Silicon nitride'
   handles.current_data = handles.SiliconNitride;
   set(handles.text2,'String',handles.current_data);
case 38 %'Sodium chloride'
   handles.current_data = handles.SodiumChloride;
   set(handles.text2,'String',handles.current_data);
case 39 %'Steatite'
   handles.current_data = handles.Steatite;
   set(handles.text2,'String',handles.current_data);
case 40 %'Styrofoam'
   handles.current_data = handles.Styrofoam;
   set(handles.text2,'String',handles.current_data);
case 41 %'Sulfur'
   handles.current_data = handles.Sulfur;
   set(handles.text2,'String',handles.current_data);
case 42 %'Tantalum pentoxide'
   handles.current_data = handles.Tantalum;
   set(handles.text2,'String',handles.current_data);
case 43 %'Teflon'
   handles.current_data = handles.Teflon;
   set(handles.text2,'String',handles.current_data);
case 44 %'Vacuum'
   handles.current_data = handles.Vacuum;
   set(handles.text2,'String',handles.current_data);
case 45 %'Vaseline'
   handles.current_data = handles.Vaseline;
   set(handles.text2,'String',handles.current_data);
case 46 %'Water'
   handles.current_data = handles.Water;
   set(handles.text2,'String',handles.current_data);
case 47 %'Wet soil'
   handles.current_data = handles.WetSoil;
   set(handles.text2,'String',handles.current_data);
case 48 %'Wood'
   handles.current_data = handles.Wood;
   set(handles.text2,'String',handles.current_data);
        
end
% Save the handles structure.
guidata(hObject,handles)

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
